--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Paris
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "pa_factorykeep" }
DefineCharacter { name = "pa_moulinkeep" }
DefineCharacter { name = "pa_marketkeep" }
DefineCharacter { name = "pa_shopkeep" }
DefineCharacter { name = "pa_towerkeep" }
DefineCharacter { name = "pa_cafekeep" }
DefineCharacter { name = "pa_notredamekeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "paris",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg", 
	
	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_01", time=130000, loop=true, htile=true, path={{800,120},{700,120},{100,120},{0,120}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.3, time=12000,hold=5000,bounce=true,
			path={{-16,-13},{394,92},{571,6},{841,43},},
		},
	
		GenericBuilding { name="pa_tower", character="pa_towerkeep", x=419+240/2,y=0+257/2, },
		
		
		Factory { name="pa_factory", character="pa_factorykeep", price = 500000, x=445+147/2,y=186+134/2, },
		PlayerLogo { name="logo", x=473+100/2,y=180+57/2, scale=0.286, target="pa_factory" },
		
		SpriteLayer { image="pa_factorymask", x=437+33/2,y=205+162/2, },
		EmptyBuilding { name="pa_notredame", character={"pa_notredamekeep"}, ambient="sfx/other_loop.ogg", x=9+273/2,y=1+179/2, },
		SpriteLayer { image="pa_notredamemask", x=52+174/2,y=108+218/2, },
		EmptyBuilding { name="pa_moulin", character={"pa_moulinkeep"}, ambient="sfx/market_loop.ogg", x=67+71/2,y=192+140/2, },
		Shop { name="pa_shop", character="pa_shopkeep", x=135+72/2,y=203+131/2, labely=295 },
		
		-- Far Cars
		SpriteLayer { imagelist=portCars, scale=.35, time=17000,hold=3000, bounce=true, path={{-78,328},{278,330},{382,332},{406,326},{410,309},{500,333},{752,299}},},
		SpriteLayer { imagelist=portCars, scale=.35, time=17000,hold=5000, bounce=true, path={{-78,330},{278,332},{382,334},{406,328},{410,311},{500,335},{752,301}},},

		SpriteLayer { image="pa_shopmask", x=203+59/2,y=98+264/2, },
		SpriteLayer { image="pa_moulinmask", x=0+94/2,y=21+385/2, },
		SpriteLayer { image="pa_carmask", x=428+38/2,y=267+88/2, },
		
		Market { name="pa_market", character="pa_marketkeep", x=237+213/2,y=36+354/2,
			inventory = { caramel=true, sugar=true, cherry=true, milk=true, hazelnut=true, cognac=true } },
		EmptyBuilding { name="pa_cafe", character={"pa_cafekeep"}, ambient="sfx/saloon_loop.ogg", x=556+180/2,y=44+332/2, },
		
		-- Mid Cars
		SpriteLayer { imagelist=portCars, scale=1.2, time=12000,hold=2000,bounce=true, path={{-85,430},{521,368},{627,367},{889,359},{872,385},{713,375},{481,383},{-94,452}},},
		SpriteLayer { imagelist=portCars, scale=1.2, time=10000,hold=6000,bounce=true, path={{-88,441},{523,360},{625,360},{889,374}},},


		SpriteLayer { image="pa_cafemask", x=709+91/2,y=20+407/2, },
		
		SpriteLayer { image="pa_lamp", x=548+32/2,y=216+208/2, },
	}
}
